library(xlsx)
library(ggplot2)
library(tidyverse)

Data <- read.xlsx('Bird_CoM_Data.xlsx', sheetIndex = 1, row.names = 1)

names = row.names(Data)

COM <- data.frame(Data[,2], Data[,3], Data[,4])
rownames(COM) <- names
colnames(COM) <- c("Class", "DV", "CC")


hull <- COM %>%
  group_by(Class) %>%
  slice(chull(CC, DV))

hull$Class <- factor(hull$Class, levels=c("1_FLD", "2_HLD", "3_Duck"), labels=c("Forelimb-dominant birds", "Hindlimb-dominant birds", "Duck breeds"))
COM$Class <- factor(COM$Class, levels=c("1_FLD", 
                                        "2_HLD", 
                                        "3_MA",
                                        "4_AY",
                                        "5_IR"), 
                    labels=c("Forelimb-dominant birds", 
                             "Hindlimb-dominant birds", 
                             "Mallard",
                             "Aylesbury",
                             "Indian runner"))
hull <- hull[1:11,]

plotnames <- c("M1", "M2", "AY", "IR")

tiff(filename = "Bird_CoM.tif", width = 222, height = 166, units = "mm", res = 600, compression = "lzw") #166x166*2 or 166x166*1.5

plot.new()

ggplot(COM, aes(CC, DV)) +
    geom_polygon(data = hull, aes(fill=Class), alpha = 0.5, show.legend = FALSE) +
    geom_point((aes(shape=Class, fill=Class, color=Class, colour=id, size=Class)), colour = "black",show.legend = TRUE) + 
    scale_x_continuous(position = "top") +
    scale_shape_manual(values=c(24, 25, 22, 21, 23))+
    scale_fill_manual(values = c("lightslateblue", 
                                 "lightcoral", 
                                 "lightyellow3",
                                 "sienna3",
                                 "skyblue4")) +
    scale_size_manual(values = c(2, 2, 4, 4, 4)) +
    xlab(bquote('Cranio-Caudal CoM Position '('Distance in front of hip/body mass'^0.33))) +
    ylab(bquote('Dorso-Ventral CoM Position '('Distance below hip/body mass'^0.33))) +
    theme_bw() +
    theme(axis.text=element_text(size=10), axis.title=element_text(size=12)) +
    theme(legend.position = c(0.85, 0.20), legend.background = element_blank(), legend.title = element_blank(), legend.key = element_blank()) +
    theme(panel.grid.major = element_blank(),panel.grid.minor = element_blank())

    
dev.off()



